*! version 2.0.0 GA/PR 17Oct00
program define gamplot
version 6.0
/*
	Plotting program for use after gamfit
*/
if "`e(cmd)'"!="gam" { error 301 }
#delimit ;
syntax varlist(min=1 max=2) [if] [in] 
 [,SE(real .95) noCONF noPRES ABS(real 1e15) *];
#delimit cr
if "`e(fam)'"=="cox" { local pres nopres }
tokenize `varlist'
local x=trim(substr("`1'",1,6))
if !missing("`2'") {  local xvar `2' }
else local xvar `1'
quietly if "`conf'"!="noconf" {
	tempname z
	scalar `z'=invnorm((1+`se')/2)
	tempvar top bot
	gen `top'=s_`x'+`z'*e_`x'
	gen `bot'=s_`x'-`z'*e_`x'
	local pen1 "66"
	local sym1 "ii"
	local con1 "ss"
}
quietly if "`pres'"!="nopres" {
	tempvar partres
	gen `partres'=r_`x'
	lab var `partres' "GAM partial residuals for `x'"
	local pen2 "2"
	local sym2 "o"
	local con2 "."
/*
	Option for excluding points which destroy the scaling
*/
	count if abs(s_`x'-r_`x')>`abs'
	local excl=r(N)
	if `excl' {
		if `excl'>1 { local s s }
		noi di in bl "[`excl' point`s' excluded from plot]"
		replace `partres'=. if abs(s_`x'-r_`x')>`abs'
	}
}
qui count if `xvar'==e(missing)
if r(N) {
	local nimpute `r(N)'
	if `nimpute'>1 { local s s }
	else local s
	noi di in bl "[`nimpute' imputed point`s' included in plot]"
	local xlabel: var lab `xvar'
	tempvar ximpute
	qui gen `ximpute'=`xvar'
	qui summ `xvar' if `xvar'!=e(missing)
	qui replace `ximpute'=r(mean) if `xvar'==e(missing)
	lab var `ximpute' "`xlabel'"
	local xvar `ximpute'	
}
local pen "pen(3`pen1'`pen2')"
local sym "s(i`sym1'`sym2')"
local con "c(s`con1'`con2')"
graph s_`x' `top' `bot' `partres' `xvar' `if' `in', /*
 */ `sym' `con' sort `pen' `options'
end
